<?php
/**
 * توابع کمکی تلگرام
 * Telegram Helper Functions
 */

class Telegram {
    
    /**
     * ارسال درخواست به API تلگرام
     */
    public static function request($method, $data = []) {
        $url = API_URL . $method;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $result = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($result, true);
    }
    
    /**
     * ارسال پیام
     */
    public static function sendMessage($chatId, $text, $replyMarkup = null, $parseMode = 'HTML') {
        $data = [
            'chat_id' => $chatId,
            'text' => $text,
            'parse_mode' => $parseMode
        ];
        
        if ($replyMarkup) {
            $data['reply_markup'] = json_encode($replyMarkup);
        }
        
        return self::request('sendMessage', $data);
    }
    
    /**
     * ارسال فایل
     */
    public static function sendDocument($chatId, $fileId, $caption = null, $parseMode = 'HTML') {
        $data = [
            'chat_id' => $chatId,
            'document' => $fileId
        ];
        
        if ($caption) {
            $data['caption'] = $caption;
            $data['parse_mode'] = $parseMode;
        }
        
        return self::request('sendDocument', $data);
    }
    
    /**
     * ارسال عکس
     */
    public static function sendPhoto($chatId, $fileId, $caption = null, $parseMode = 'HTML') {
        $data = [
            'chat_id' => $chatId,
            'photo' => $fileId
        ];
        
        if ($caption) {
            $data['caption'] = $caption;
            $data['parse_mode'] = $parseMode;
        }
        
        return self::request('sendPhoto', $data);
    }
    
    /**
     * ارسال ویدیو
     */
    public static function sendVideo($chatId, $fileId, $caption = null, $parseMode = 'HTML') {
        $data = [
            'chat_id' => $chatId,
            'video' => $fileId
        ];
        
        if ($caption) {
            $data['caption'] = $caption;
            $data['parse_mode'] = $parseMode;
        }
        
        return self::request('sendVideo', $data);
    }
    
    /**
     * ارسال فایل صوتی
     */
    public static function sendAudio($chatId, $fileId, $caption = null, $parseMode = 'HTML') {
        $data = [
            'chat_id' => $chatId,
            'audio' => $fileId
        ];
        
        if ($caption) {
            $data['caption'] = $caption;
            $data['parse_mode'] = $parseMode;
        }
        
        return self::request('sendAudio', $data);
    }
    
    /**
     * ارسال ویس
     */
    public static function sendVoice($chatId, $fileId, $caption = null, $parseMode = 'HTML') {
        $data = [
            'chat_id' => $chatId,
            'voice' => $fileId
        ];
        
        if ($caption) {
            $data['caption'] = $caption;
            $data['parse_mode'] = $parseMode;
        }
        
        return self::request('sendVoice', $data);
    }
    
    /**
     * فوروارد کردن پیام
     */
    public static function forwardMessage($chatId, $fromChatId, $messageId) {
        $data = [
            'chat_id' => $chatId,
            'from_chat_id' => $fromChatId,
            'message_id' => $messageId
        ];
        
        return self::request('forwardMessage', $data);
    }
    
    /**
     * دریافت اطلاعات فایل
     */
    public static function getFile($fileId) {
        return self::request('getFile', ['file_id' => $fileId]);
    }
    
    /**
     * دانلود فایل از سرور تلگرام
     */
    public static function downloadFile($filePath, $destination) {
        $url = "https://api.telegram.org/file/bot" . BOT_TOKEN . "/" . $filePath;
        
        $ch = curl_init($url);
        $fp = fopen($destination, 'wb');
        
        curl_setopt($ch, CURLOPT_FILE, $fp);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        curl_exec($ch);
        curl_close($ch);
        fclose($fp);
        
        return file_exists($destination);
    }
    
    /**
     * بررسی اینکه کاربر ادمین است یا نه
     */
    public static function isAdmin($userId) {
        return Database::isAdmin($userId);
    }
    
    /**
     * ارسال اکشن (typing, upload_document, ...)
     */
    public static function sendChatAction($chatId, $action) {
        return self::request('sendChatAction', [
            'chat_id' => $chatId,
            'action' => $action
        ]);
    }
    
    /**
     * بررسی عضویت کاربر در کانال
     */
    public static function checkUserInChannel($userId, $channelId) {
        $result = self::request('getChatMember', [
            'chat_id' => $channelId,
            'user_id' => $userId
        ]);
        
        if (isset($result['result']['status'])) {
            $status = $result['result']['status'];
            return in_array($status, ['member', 'administrator', 'creator']);
        }
        
        return false;
    }
    
    /**
     * ساخت کیبورد Reply
     */
    public static function makeKeyboard($buttons, $resize = true, $oneTime = false) {
        return [
            'keyboard' => $buttons,
            'resize_keyboard' => $resize,
            'one_time_keyboard' => $oneTime
        ];
    }
    
    /**
     * ساخت کیبورد Inline
     */
    public static function makeInlineKeyboard($buttons) {
        return [
            'inline_keyboard' => $buttons
        ];
    }
    
    /**
     * حذف کیبورد
     */
    public static function removeKeyboard() {
        return [
            'remove_keyboard' => true
        ];
    }
    
    /**
     * کیبورد پنل ادمین
     */
    public static function getAdminKeyboard() {
        return self::makeKeyboard([
            [
                ['text' => '📊 آمار کاربران'],
                ['text' => '📁 فایل‌های من']
            ],
            [
                ['text' => '📤 آپلود فایل'],
                ['text' => '🖥 وضعیت سرور']
            ],
            [
                ['text' => '📢 پیام همگانی'],
                ['text' => '👥 مدیریت ادمین‌ها']
            ],
            [
                ['text' => '⚠️ اخطار به کاربران'],
                ['text' => '📋 اعتراضات']
            ],
            [
                ['text' => '⚙️ تنظیمات'],
                ['text' => '📋 راهنما']
            ]
        ]);
    }
    
    /**
     * کیبورد کاربران عادی (داینامیک)
     */
    public static function getUserKeyboard() {
        $settings = Database::getSettings();
        $buttons = [];
        
        // دکمه اطلاعات من
        if (!isset($settings['user_button_info']) || $settings['user_button_info']) {
            $buttons[] = [
                ['text' => '👤 اطلاعات من']
            ];
        }
        
        // دکمه فایل‌های دانلود شده
        if (!isset($settings['user_button_downloads']) || $settings['user_button_downloads']) {
            $buttons[] = [
                ['text' => '📥 فایل‌های دانلود شده']
            ];
        }
        
        // دکمه بهترین فایل‌ها
        if (!isset($settings['user_button_toprated']) || $settings['user_button_toprated']) {
            $buttons[] = [
                ['text' => '⭐ بهترین فایل‌ها']
            ];
        }
        
        // اگر هیچ دکمه‌ای فعال نیست، حداقل یک دکمه نمایش بده
        if (empty($buttons)) {
            $buttons[] = [
                ['text' => '📱 منوی اصلی']
            ];
        }
        
        return self::makeKeyboard($buttons);
    }    
    /**
     * کیبورد انتخاب نوع آپلود
     */
    public static function getUploadTypeKeyboard() {
        return self::makeKeyboard([
            [
                ['text' => '📎 آپلود از تلگرام']
            ],
            [
                ['text' => '🔗 آپلود از لینک']
            ],
            [
                ['text' => '🔙 بازگشت']
            ]
        ]);
    }    
    /**
     * کیبورد تنظیمات
     */
    public static function getSettingsKeyboard() {
        $settings = Database::getSettings();
        
        $maintenanceText = $settings['maintenance_mode'] ? '🔴 غیرفعال کردن تعمیر' : '🟢 فعال کردن تعمیر';
        $forceJoinText = $settings['force_join'] ? '🔴 غیرفعال جوین اجباری' : '🟢 فعال جوین اجباری';
        
        return self::makeKeyboard([
            [
                ['text' => $maintenanceText]
            ],
            [
                ['text' => $forceJoinText]
            ],
            [
                ['text' => '📢 مدیریت کانال‌ها']
            ],
            [
                ['text' => '🔔 اطلاع‌رسانی آپلود']
            ],
            [
                ['text' => '🎛 مدیریت دکمه‌های کاربران']
            ],
            [
                ['text' => '🔙 بازگشت']
            ]
        ]);
    }
    
    /**
     * کیبورد مدیریت کانال‌ها
     */
    public static function getChannelsKeyboard() {
        return self::makeKeyboard([
            [
                ['text' => '📋 لیست کانال‌ها']
            ],
            [
                ['text' => '➕ افزودن کانال']
            ],
            [
                ['text' => '➖ حذف کانال']
            ],
            [
                ['text' => '🔙 بازگشت به تنظیمات']
            ]
        ]);
    }
}
