<?php
/**
 * هندلر استارت
 * Start Command Handler
 */

function handleStart($chatId, $firstName, $userId, $username, $lastName) {
    // بررسی بلاک بودن کاربر
    if (Database::isUserBlocked($userId)) {
        $message = "🚫 " . HTMLParser::format("دسترسی مسدود شد!", true) . "\n\n";
        $message .= HTMLParser::blockquote("شما از استفاده از ربات محروم شده‌اید.");
        
        Telegram::sendMessage($chatId, $message);
        return;
    }
    
    // ثبت کاربر در دیتابیس
    Database::addUser($userId, $username, $firstName, $lastName);
    
    // ارسال پیام خوش‌آمدگویی
    $message = HTMLParser::welcomeMessage($firstName);
    
    // کیبورد مناسب برای ادمین یا کاربر عادی
    $keyboard = Telegram::isAdmin($userId) ? Telegram::getAdminKeyboard() : Telegram::getUserKeyboard();
    
    Telegram::sendMessage($chatId, $message, $keyboard);
}

/**
 * ارسال فایل به کاربر (بعد از تایید)
 */
function sendFileToUser($chatId, $userId, $parameter, $messageId = null) {
    $fileData = Database::getFile($parameter);
    
    if (!$fileData) {
        $message = "❌ " . HTMLParser::format("فایل یافت نشد!", true) . "\n\n";
        $message .= HTMLParser::blockquote("لینک نامعتبر است یا فایل حذف شده است.");
        
        if ($messageId) {
            Telegram::request('editMessageText', [
                'chat_id' => $chatId,
                'message_id' => $messageId,
                'text' => $message,
                'parse_mode' => 'HTML'
            ]);
        } else {
            Telegram::sendMessage($chatId, $message);
        }
        return;
    }
    
    // ارسال فایل بر اساس نوع
    Telegram::sendChatAction($chatId, 'upload_document');
    
    $fileType = $fileData['file_type'];
    $fileId = $fileData['file_id'];
    $caption = !empty($fileData['caption']) ? $fileData['caption'] : ("📁 " . $fileData['file_name']);
    
    if (in_array($fileType, ['photo', 'image'])) {
        Telegram::sendPhoto($chatId, $fileId, $caption);
    } elseif ($fileType == 'video') {
        Telegram::sendVideo($chatId, $fileId, $caption);
    } elseif ($fileType == 'audio') {
        Telegram::sendAudio($chatId, $fileId, $caption);
    } elseif ($fileType == 'voice') {
        Telegram::sendVoice($chatId, $fileId, $caption);
    } else {
        Telegram::sendDocument($chatId, $fileId, $caption);
    }
    
    // افزایش شمارنده دانلود
    Database::incrementDownload($parameter);
    
    // ثبت آمار دانلود کاربر
    Database::recordUserDownload($userId, $fileData['file_size']);
    
    // ثبت فایل در لیست دانلودهای کاربر
    Database::addDownloadedFile($userId, $parameter);
    
    // پیام تشکر
    $thanksMessage = "✅ " . HTMLParser::format("فایل با موفقیت ارسال شد", true) . "\n\n";
    $thanksMessage .= HTMLParser::blockquote("از استفاده شما متشکریم! 💙");
    
    Telegram::sendMessage($chatId, $thanksMessage);
    
    // درخواست امتیازدهی (فقط برای کاربران عادی)
    if (!Telegram::isAdmin($userId)) {
        askForRating($chatId, $userId, $parameter);
    }
}

/**
 * نمایش پیشنمایش فایل به کاربر
 */
function handleStartWithParameter($chatId, $userId, $firstName, $parameter) {
    // بررسی بلاک بودن کاربر
    if (Database::isUserBlocked($userId)) {
        $message = "🚫 " . HTMLParser::format("دسترسی مسدود شد!", true) . "\n\n";
        $message .= HTMLParser::blockquote("شما از استفاده از ربات محروم شده‌اید.");
        
        Telegram::sendMessage($chatId, $message);
        return;
    }
    
    // بررسی اینکه parameter یک آیدی فایل معتبر است
    $fileData = Database::getFile($parameter);
    
    if (!$fileData) {
        $message = "❌ " . HTMLParser::format("فایل یافت نشد!", true) . "\n\n";
        $message .= HTMLParser::blockquote("لینک نامعتبر است یا فایل حذف شده است.");
        
        Telegram::sendMessage($chatId, $message);
        return;
    }
    
    // ثبت کاربر
    Database::addUser($userId, '', $firstName, '');
    
    // بررسی فعال بودن فایل
    if (!$fileData['is_active']) {
        $message = "❌ " . HTMLParser::format("فایل غیرفعال شده است!", true) . "\n\n";
        $message .= HTMLParser::blockquote("این فایل دیگر قابل دانلود نیست");
        
        Telegram::sendMessage($chatId, $message);
        return;
    }
    
    // بررسی تاریخ انقضا
    if (!empty($fileData['expire_date'])) {
        $expireTime = strtotime($fileData['expire_date']);
        if ($expireTime && time() > $expireTime) {
            $message = "⏰ " . HTMLParser::format("فایل منقضی شده است!", true) . "\n\n";
            $message .= HTMLParser::blockquote("تاریخ انقضای این فایل گذشته است");
            
            Telegram::sendMessage($chatId, $message);
            return;
        }
    }
    
    // بررسی محدودیت دانلود
    if ($fileData['download_limit'] > 0 && $fileData['download_count'] >= $fileData['download_limit']) {
        $message = "⚠️ " . HTMLParser::format("محدودیت دانلود", true) . "\n\n";
        $message .= HTMLParser::blockquote("این فایل به حداکثر تعداد دانلود رسیده است");
        
        Telegram::sendMessage($chatId, $message);
        return;
    }
    
    // بررسی جوین اجباری (اگر برای این فایل فعال باشد)
    $settings = Database::getSettings();
    if ($fileData['force_join_enabled'] && $settings['force_join']) {
        $channels = Database::getForceJoinChannels();
        
        if (!empty($channels)) {
            $notJoinedChannels = [];
            
            // بررسی عضویت در تمام کانال‌ها
            foreach ($channels as $channel) {
                $isMember = Telegram::checkUserInChannel($userId, $channel['id']);
                
                if (!$isMember) {
                    $notJoinedChannels[] = $channel;
                }
            }
            
            // اگر در همه کانال‌ها عضو نیست
            if (!empty($notJoinedChannels)) {
                $message = "⚠️ " . HTMLParser::format("عضویت الزامی!", true) . "\n\n";
                $message .= "برای دانلود فایل، ابتدا باید در کانال‌های زیر عضو شوید:\n\n";
                
                // ساخت لیست کانال‌ها
                $channelsList = "📢 کانال‌های الزامی:\n";
                foreach ($notJoinedChannels as $ch) {
                    $channelsList .= "• " . ($ch['title'] ?: $ch['username']) . "\n";
                }
                
                $message .= HTMLParser::blockquote($channelsList);
                
                // ساخت دکمه‌های Inline
                $buttons = [];
                foreach ($notJoinedChannels as $channel) {
                    $username = ltrim($channel['username'], '@');
                    $buttons[] = [
                        ['text' => '📢 ' . ($channel['title'] ?: $channel['username']), 'url' => "https://t.me/{$username}"]
                    ];
                }
                
                $buttons[] = [
                    ['text' => '✅ عضو شدم - بررسی مجدد', 'callback_data' => 'check_join_' . $parameter]
                ];
                
                $keyboard = Telegram::makeInlineKeyboard($buttons);
                
                Telegram::sendMessage($chatId, $message, $keyboard);
                return;
            }
        }
    }
    
    // بررسی رمز عبور فایل
    if (Database::fileHasPassword($parameter)) {
        // درخواست رمز از کاربر
        $message = "🔐 " . HTMLParser::format("فایل محافظت شده", true) . "\n\n";
        $message .= HTMLParser::blockquote("این فایل با رمز عبور محافظت شده است");
        $message .= "\n\nلطفاً رمز عبور را وارد کنید:";
        
        // ذخیره file ID برای بعد
        Database::setPasswordAttempt($userId, $parameter, '');
        
        Telegram::sendMessage($chatId, $message);
        return;
    }
    
    // نمایش پیشنمایش فایل
    $previewMessage = "📦 " . HTMLParser::format("پیشنمایش فایل", true) . "\n\n";
    
    // اطلاعات فایل
    $fileInfo = "📄 نام فایل: " . HTMLParser::format($fileData['file_name'], true) . "\n";
    $fileInfo .= "💾 حجم: " . HTMLParser::format(HTMLParser::formatFileSize($fileData['file_size']), true) . "\n";
    $fileInfo .= "📥 تعداد دانلود: " . HTMLParser::format(number_format($fileData['download_count']), true) . "\n";
    
    // نمایش کپشن اگر وجود دارد
    if (!empty($fileData['caption'])) {
        $fileInfo .= "\n📝 توضیحات:\n" . $fileData['caption'] . "\n";
    }
    
    // نمایش محدودیت دانلود
    if ($fileData['download_limit'] > 0) {
        $remaining = $fileData['download_limit'] - $fileData['download_count'];
        $fileInfo .= "\n⚠️ محدودیت: " . HTMLParser::format($remaining . " دانلود باقیمانده", true);
    }
    
    // نمایش تاریخ انقضا
    if (!empty($fileData['expire_date'])) {
        $expireDate = date('Y/m/d H:i', strtotime($fileData['expire_date']));
        $fileInfo .= "\n⏰ انقضا: " . HTMLParser::format($expireDate, true);
    }
    
    // نمایش امتیاز
    if (isset($fileData['total_ratings']) && $fileData['total_ratings'] > 0) {
        $fileInfo .= "\n⭐ امتیاز: " . HTMLParser::ratingDisplay($fileData['average_rating'], $fileData['total_ratings']);
    }
    
    $previewMessage .= HTMLParser::blockquote($fileInfo);
    $previewMessage .= "\n\nآیا مایل به دانلود این فایل هستید؟";
    
    // دکمه تایید دانلود
    $keyboard = Telegram::makeInlineKeyboard([
        [
            ['text' => '✅ تأیید و دانلود', 'callback_data' => 'download_file_' . $parameter]
        ],
        [
            ['text' => '❌ انصراف', 'callback_data' => 'cancel_download']
        ]
    ]);
    
    Telegram::sendMessage($chatId, $previewMessage, $keyboard);
}
